/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.objects;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.testng.IClass;
import org.testng.IInjectorFactory;
import org.testng.IModule;
import org.testng.IModuleFactory;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.TestNGException;
import org.testng.annotations.Guice;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.ClassHelper;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.invokers.objects.GuiceContext;
import org.testng.internal.objects.InstanceCreator;

class GuiceHelper {
    private final Map<List<Module>, Injector> m_injectors = Maps.newHashMap();
    private final ListMultiMap<Class<? extends Module>, Module> m_guiceModules = Maps.newListMultiMap();
    private final String parentModule;
    private final String stageString;
    private final String testName;
    private final ITestContext context;
    private static final BiPredicate<Module, Module> CLASS_EQUALITY = (m, n) -> m.getClass().equals(n.getClass());

    GuiceHelper(ITestContext context) {
        this.parentModule = context.getSuite().getParentModule();
        this.stageString = context.getSuite().getGuiceStage();
        this.testName = context.getName();
        this.context = context;
    }

    GuiceHelper(GuiceContext context) {
        this.parentModule = context.getParentModule();
        this.stageString = context.getGuiceStage();
        this.testName = context.getName();
        this.context = null;
    }

    Injector getInjector(IClass iClass, IInjectorFactory injectorFactory) {
        return this.getInjector(iClass.getRealClass(), injectorFactory);
    }

    Injector getInjector(Class<?> cls, IInjectorFactory injectorFactory) {
        Guice guice = AnnotationHelper.findAnnotationSuperClasses(Guice.class, cls);
        if (guice == null) {
            return null;
        }
        Injector parentInjector = this.getParentInjector(injectorFactory);
        List<Module> classLevelModules = this.getModules(guice, parentInjector, cls);
        Injector injector = this.getInjector(classLevelModules);
        if (injector == null) {
            injector = this.createInjector(parentInjector, injectorFactory, classLevelModules);
            this.addInjector(classLevelModules, injector);
        }
        return injector;
    }

    private Injector getParentInjector(IInjectorFactory factory) {
        Injector injector = null;
        ISuite suite = null;
        if (this.context != null) {
            suite = this.context.getSuite();
            injector = suite.getParentInjector();
        }
        if (injector == null) {
            Module parentModule = this.getParentModule();
            injector = this.createInjector(null, factory, parentModule == null ? Collections.emptyList() : Collections.singletonList(parentModule));
            if (suite != null) {
                suite.setParentInjector(injector);
            }
        }
        return injector;
    }

    private void addInjector(List<Module> moduleInstances, Injector injector) {
        this.m_injectors.put(moduleInstances, injector);
    }

    Injector getInjector(List<Module> moduleInstances) {
        return this.m_injectors.get(moduleInstances);
    }

    public void addGuiceModule(Module module) {
        Class<?> cls = module.getClass();
        List modules = (List)this.m_guiceModules.get(cls);
        boolean found = modules.stream().anyMatch(each -> each.getClass().equals(cls));
        if (!found) {
            modules.add(module);
        }
    }

    private List<Module> getGuiceModules(Class<? extends Module> cls) {
        return (List)this.m_guiceModules.get(cls);
    }

    private Module getParentModule() {
        Module obj;
        Class<? extends Module> parentModule = this.getParentModuleClass();
        if (parentModule == null) {
            return null;
        }
        List<Module> allModules = this.getGuiceModules(parentModule);
        if (!allModules.isEmpty()) {
            if (allModules.size() > 1) {
                throw new IllegalStateException("Found more than 1 module associated with the test <" + this.testName + ">");
            }
            return allModules.get(0);
        }
        try {
            Constructor<? extends Module> moduleConstructor = parentModule.getDeclaredConstructor(ITestContext.class);
            obj = InstanceCreator.newInstance(moduleConstructor, this.context);
        }
        catch (NoSuchMethodException e) {
            obj = InstanceCreator.newInstance(parentModule);
        }
        this.addGuiceModule(obj);
        return obj;
    }

    private Class<? extends Module> getParentModuleClass() {
        if (Utils.isStringEmpty(this.parentModule)) {
            return null;
        }
        Class<?> parentModule = ClassHelper.forName(this.parentModule);
        if (parentModule == null) {
            throw new TestNGException("Cannot load parent Guice module class: " + this.parentModule);
        }
        if (!Module.class.isAssignableFrom(parentModule)) {
            throw new TestNGException("Provided class is not a Guice module: " + parentModule.getName());
        }
        return parentModule;
    }

    private Injector createInjector(Injector parent, IInjectorFactory injectorFactory, List<Module> moduleInstances) {
        Stage stage = Stage.DEVELOPMENT;
        if (Utils.isStringNotEmpty(this.stageString)) {
            stage = Stage.valueOf((String)this.stageString);
        }
        moduleInstances.forEach(this::addGuiceModule);
        Module[] modules = moduleInstances.toArray(new Module[0]);
        if (parent == null || this.getParentModuleClass() == null) {
            return injectorFactory.getInjector(null, stage, modules);
        }
        return injectorFactory.getInjector(parent, stage, modules);
    }

    private List<Module> getModules(Guice guice, Injector parentInjector, Class<?> testClass) {
        IModuleFactory factoryInstance;
        Module module;
        List<Module> result = Lists.newArrayList();
        for (Class<? extends Module> moduleClass : guice.modules()) {
            List<Module> modules = this.getGuiceModules(moduleClass);
            if (modules != null && !modules.isEmpty()) {
                result.addAll(modules);
                result = Lists.merge(result, CLASS_EQUALITY, modules);
                continue;
            }
            Module instance = (Module)parentInjector.getInstance(moduleClass);
            result = Lists.merge(result, CLASS_EQUALITY, Collections.singletonList(instance));
            this.addGuiceModule(instance);
        }
        Class<? extends IModuleFactory> factory = guice.moduleFactory();
        if (factory != IModuleFactory.class && (module = (factoryInstance = (IModuleFactory)parentInjector.getInstance(factory)).createModule(this.context, testClass)) != null) {
            result = Lists.merge(result, CLASS_EQUALITY, Collections.singletonList(module));
        }
        result = Lists.merge(result, CLASS_EQUALITY, LazyHolder.getSpiModules());
        return result;
    }

    private static final class LazyHolder {
        private static final List<Module> spiModules = LazyHolder.loadModules();

        private LazyHolder() {
        }

        private static List<Module> loadModules() {
            return StreamSupport.stream(ServiceLoader.load(IModule.class).spliterator(), false).map(IModule::getModule).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }

        public static List<Module> getSpiModules() {
            return spiModules;
        }
    }
}

