/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.PrivateMembersLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PrivateMemberBodiesLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class PrivateMemberBodiesLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    public PrivateMemberBodiesLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        irBody.transform((IrTransformer)new IrElementTransformerVoid(){

            /*
             * Enabled aggressive block sorting
             */
            public IrExpression visitCall(IrCall expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                super.visitCall(expression2);
                IrElementBase irElementBase = PrivateMembersLoweringKt.access$getCorrespondingStatic(expression2.getSymbol().getOwner());
                if (irElementBase != null) {
                    IrSimpleFunction it = irElementBase;
                    boolean bl = false;
                    IrCall irCall = this.transformPrivateToStaticCall(expression2, it);
                    irElementBase = irCall;
                    if (irCall != null) {
                        irExpression = (IrExpression)irElementBase;
                        return irExpression;
                    }
                }
                irExpression = expression2;
                return irExpression;
            }

            private final IrCall transformPrivateToStaticCall(IrCall expression2, IrSimpleFunction staticTarget) {
                IrCallImpl newExpression = BuildersKt.IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), staticTarget.getSymbol(), expression2.getTypeArguments().size(), expression2.getOrigin(), expression2.getSuperQualifierSymbol());
                AddToStdlibKt.assignFrom(newExpression.getArguments(), expression2.getArguments());
                IrExpressionsKt.copyTypeArgumentsFrom$default(newExpression, expression2, 0, 2, null);
                return newExpression;
            }
        }, (Object)null);
    }
}

