/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import uk.org.webcompere.systemstubs.exception.LoadingException;

public class PropertySource {
    public static Properties fromFile(Path path) {
        return PropertySource.fromFile(path.toFile());
    }

    public static Properties fromFile(String path) {
        return PropertySource.fromFile(Paths.get(path, new String[0]));
    }

    public static Properties fromFile(File file) {
        try {
            return PropertySource.fromInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new LoadingException("Cannot read file: " + file.getAbsolutePath(), e);
        }
    }

    public static Properties fromResource(String resourceName) {
        return PropertySource.fromInputStream(PropertySource.class.getClassLoader().getResourceAsStream(resourceName));
    }

    public static Properties fromInputStream(InputStream stream) {
        Properties properties;
        block8: {
            InputStream read = stream;
            try {
                Properties properties2 = new Properties();
                properties2.load(read);
                properties = properties2;
                if (read == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (read != null) {
                        try {
                            read.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new LoadingException("Could not load values", e);
                }
            }
            read.close();
        }
        return properties;
    }
}

