/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Factory;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.resolve.result.BuildableArtifactFileResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;

public class FilteredModuleComponentRepository
implements ModuleComponentRepository<ModuleComponentGraphResolveState> {
    private final ModuleComponentRepository<ModuleComponentGraphResolveState> delegate;
    private final Action<? super ArtifactResolutionDetails> filterAction;

    public FilteredModuleComponentRepository(ModuleComponentRepository<ModuleComponentGraphResolveState> delegate, Action<? super ArtifactResolutionDetails> filterAction) {
        this.delegate = delegate;
        this.filterAction = filterAction;
    }

    public Action<? super ArtifactResolutionDetails> getFilterAction() {
        return this.filterAction;
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> getLocalAccess() {
        return new FilteringAccess(this.delegate.getLocalAccess());
    }

    @Override
    public ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> getRemoteAccess() {
        return new FilteringAccess(this.delegate.getRemoteAccess());
    }

    @Override
    public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
        return this.delegate.getArtifactCache();
    }

    @Override
    @Nullable
    public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
        return this.delegate.getComponentMetadataSupplier();
    }

    private class FilteringAccess
    implements ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> {
        private final ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> delegate;

        private FilteringAccess(ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
            ModuleIdentifier identifier = dependency.getSelector().getModuleIdentifier();
            this.whenModulePresent(identifier, null, () -> this.delegate.listModuleVersions(dependency, result), () -> result.listed(Collections.emptyList()));
        }

        @Override
        public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentGraphResolveState> result) {
            this.whenModulePresent(moduleComponentIdentifier.getModuleIdentifier(), moduleComponentIdentifier, () -> this.delegate.resolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result), result::missing);
        }

        @Override
        public void resolveArtifactsWithType(ComponentArtifactResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            this.delegate.resolveArtifactsWithType(component, artifactType, result);
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactFileResolveResult result) {
            this.delegate.resolveArtifact(artifact, moduleSources, result);
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            return (MetadataFetchingCost)((Object)this.whenModulePresent(moduleComponentIdentifier.getModuleIdentifier(), moduleComponentIdentifier, () -> this.delegate.estimateMetadataFetchingCost(moduleComponentIdentifier), () -> MetadataFetchingCost.FAST));
        }

        private void whenModulePresent(ModuleIdentifier id, @Nullable ModuleComponentIdentifier moduleComponentIdentifier, Runnable present, Runnable absent) {
            DefaultArtifactResolutionDetails details = new DefaultArtifactResolutionDetails(id, moduleComponentIdentifier);
            FilteredModuleComponentRepository.this.filterAction.execute((Object)details);
            if (details.notFound) {
                absent.run();
            } else {
                present.run();
            }
        }

        private <T> T whenModulePresent(ModuleIdentifier id, ModuleComponentIdentifier moduleComponentIdentifier, Factory<T> present, Factory<T> absent) {
            DefaultArtifactResolutionDetails details = new DefaultArtifactResolutionDetails(id, moduleComponentIdentifier);
            FilteredModuleComponentRepository.this.filterAction.execute((Object)details);
            if (details.notFound) {
                return (T)absent.create();
            }
            return (T)present.create();
        }
    }

    private static class DefaultArtifactResolutionDetails
    implements ArtifactResolutionDetails {
        private final ModuleIdentifier moduleIdentifier;
        private final ModuleComponentIdentifier moduleComponentIdentifier;
        private boolean notFound;

        private DefaultArtifactResolutionDetails(ModuleIdentifier moduleIdentifier, @Nullable ModuleComponentIdentifier componentId) {
            this.moduleIdentifier = moduleIdentifier;
            this.moduleComponentIdentifier = componentId;
        }

        @Override
        public ModuleIdentifier getModuleId() {
            return this.moduleIdentifier;
        }

        @Override
        @Nullable
        public ModuleComponentIdentifier getComponentId() {
            return this.moduleComponentIdentifier;
        }

        @Override
        public boolean isVersionListing() {
            return this.moduleComponentIdentifier == null;
        }

        @Override
        public void notFound() {
            this.notFound = true;
        }
    }
}

