/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.StartParameter;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.DefaultResolverResults;
import org.gradle.api.internal.artifacts.GlobalDependencyResolutionRules;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.capability.CapabilitySelectorSerializer;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResolvedConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.InMemoryResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.TypedResolveException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ExternalModuleComponentResolverFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResolverProviderFactories;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResolverProviderFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolversChain;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.DependencyGraphResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedArtifactsBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultVisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSetResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactsGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VariantArtifactSetCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.CompositeDependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.CompositeDependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.Conflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.FailOnVersionConflictGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.VersionConflictException;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.DefaultVisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.DefaultResolvedConfigurationBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolutionFailureCollector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedConfigurationDependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsLoader;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedLocalComponentsResultGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AdhocHandlingComponentResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.FileDependencyCollectingGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.StreamingResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.ResolutionResultsStoreFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.StoreSet;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedVariantFinder;
import org.gradle.api.internal.artifacts.transform.DefaultTransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.immutable.artifact.ImmutableArtifactTypeRegistry;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.cache.internal.BinaryStore;
import org.gradle.cache.internal.Store;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;
import org.gradle.internal.locking.DependencyLockingGraphVisitor;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resolve.resolver.ResolvedVariantCache;
import org.gradle.operations.dependencies.configurations.ConfigurationIdentity;

public class ResolutionExecutor {
    private static final Spec<DependencyMetadata> IS_LOCAL_EDGE = element -> element.getSelector() instanceof ProjectComponentSelector;
    private final DependencyGraphResolver dependencyGraphResolver;
    private final GlobalDependencyResolutionRules metadataHandler;
    private final ResolutionResultsStoreFactory storeFactory;
    private final boolean buildProjectDependencies;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ArtifactTypeRegistry artifactTypeRegistry;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final AttributeContainerSerializer attributeContainerSerializer;
    private final CapabilitySelectorSerializer capabilitySelectorSerializer;
    private final BuildIdentifier currentBuild;
    private final ResolvedArtifactSetResolver artifactSetResolver;
    private final ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory;
    private final AdhocHandlingComponentResultSerializer componentResultSerializer;
    private final ResolvedVariantCache resolvedVariantCache;
    private final GraphVariantSelector graphVariantSelector;
    private final ProjectStateRegistry projectStateRegistry;
    private final LocalComponentRegistry localComponentRegistry;
    private final List<ResolverProviderFactory> resolverFactories;
    private final ExternalModuleComponentResolverFactory externalResolverFactory;
    private final ProjectDependencyResolver projectDependencyResolver;
    private final DependencyLockingProvider dependencyLockingProvider;
    private final TransformedVariantFactory transformedVariantFactory;
    private final AttributesFactory attributesFactory;
    private final DomainObjectContext domainObjectContext;
    private final TaskDependencyFactory taskDependencyFactory;
    private final ConsumerProvidedVariantFinder consumerProvidedVariantFinder;
    private final AttributeSchemaServices attributeSchemaServices;
    private final ResolutionFailureHandler resolutionFailureHandler;
    private final VariantArtifactSetCache variantArtifactSetCache;
    private final VariantTransformRegistry transformRegistry;

    @Inject
    public ResolutionExecutor(DependencyGraphResolver dependencyGraphResolver, GlobalDependencyResolutionRules metadataHandler, ResolutionResultsStoreFactory storeFactory, StartParameter startParameter, ImmutableModuleIdentifierFactory moduleIdentifierFactory, BuildOperationExecutor buildOperationExecutor, ArtifactTypeRegistry artifactTypeRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory, ComponentSelectorConverter componentSelectorConverter, AttributeContainerSerializer attributeContainerSerializer, CapabilitySelectorSerializer capabilitySelectorSerializer, BuildState currentBuild, ResolvedArtifactSetResolver artifactSetResolver, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, AdhocHandlingComponentResultSerializer componentResultSerializer, ResolvedVariantCache resolvedVariantCache, GraphVariantSelector graphVariantSelector, ProjectStateRegistry projectStateRegistry, LocalComponentRegistry localComponentRegistry, ResolverProviderFactories resolverFactories, ExternalModuleComponentResolverFactory externalResolverFactory, ProjectDependencyResolver projectDependencyResolver, DependencyLockingProvider dependencyLockingProvider, TransformedVariantFactory transformedVariantFactory, AttributesFactory attributesFactory, DomainObjectContext domainObjectContext, TaskDependencyFactory taskDependencyFactory, ConsumerProvidedVariantFinder consumerProvidedVariantFinder, AttributeSchemaServices attributeSchemaServices, ResolutionFailureHandler resolutionFailureHandler, VariantArtifactSetCache variantArtifactSetCache, VariantTransformRegistry transformRegistry) {
        this.dependencyGraphResolver = dependencyGraphResolver;
        this.metadataHandler = metadataHandler;
        this.storeFactory = storeFactory;
        this.buildProjectDependencies = startParameter.isBuildProjectDependencies();
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.buildOperationExecutor = buildOperationExecutor;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.componentSelectorConverter = componentSelectorConverter;
        this.attributeContainerSerializer = attributeContainerSerializer;
        this.capabilitySelectorSerializer = capabilitySelectorSerializer;
        this.currentBuild = currentBuild.getBuildIdentifier();
        this.artifactSetResolver = artifactSetResolver;
        this.componentSelectionDescriptorFactory = componentSelectionDescriptorFactory;
        this.componentResultSerializer = componentResultSerializer;
        this.resolvedVariantCache = resolvedVariantCache;
        this.graphVariantSelector = graphVariantSelector;
        this.projectStateRegistry = projectStateRegistry;
        this.localComponentRegistry = localComponentRegistry;
        this.resolverFactories = resolverFactories.getFactories();
        this.externalResolverFactory = externalResolverFactory;
        this.projectDependencyResolver = projectDependencyResolver;
        this.dependencyLockingProvider = dependencyLockingProvider;
        this.transformedVariantFactory = transformedVariantFactory;
        this.attributesFactory = attributesFactory;
        this.domainObjectContext = domainObjectContext;
        this.taskDependencyFactory = taskDependencyFactory;
        this.consumerProvidedVariantFinder = consumerProvidedVariantFinder;
        this.attributeSchemaServices = attributeSchemaServices;
        this.resolutionFailureHandler = resolutionFailureHandler;
        this.variantArtifactSetCache = variantArtifactSetCache;
        this.transformRegistry = transformRegistry;
    }

    public ResolverResults resolveBuildDependencies(ResolveContext resolveContext, CalculatedValue<ResolverResults> futureCompleteResults) {
        ResolutionHost resolutionHost = resolveContext.getResolutionHost();
        RootComponentMetadataBuilder.RootComponentState rootComponent = resolveContext.toRootComponent();
        ImmutableAttributes requestAttributes = rootComponent.getRootVariant().getAttributes();
        ResolutionStrategy.SortOrder defaultSortOrder = resolveContext.getResolutionStrategy().getSortOrder();
        ImmutableAttributesSchema consumerSchema = rootComponent.getRootComponent().getMetadata().getAttributesSchema();
        ConfigurationIdentity configurationIdentity = resolveContext.getConfigurationIdentity();
        ResolutionFailureCollector failureCollector = new ResolutionFailureCollector(this.componentSelectorConverter);
        ResolutionStrategyInternal resolutionStrategy = resolveContext.getResolutionStrategy();
        InMemoryResolutionResultBuilder resolutionResultBuilder = new InMemoryResolutionResultBuilder(resolutionStrategy.getIncludeAllSelectableVariantResults());
        ResolvedLocalComponentsResultGraphVisitor localComponentsVisitor = new ResolvedLocalComponentsResultGraphVisitor(this.currentBuild, this.projectStateRegistry);
        DefaultResolvedArtifactsBuilder artifactsBuilder = new DefaultResolvedArtifactsBuilder(this.buildProjectDependencies);
        ComponentResolvers resolvers = this.getResolvers(resolveContext, Collections.emptyList(), consumerSchema, (AttributeContainerInternal)requestAttributes);
        ImmutableArtifactTypeRegistry immutableArtifactTypeRegistry = this.attributeSchemaServices.getArtifactTypeRegistryFactory().create(this.artifactTypeRegistry);
        ResolvedArtifactsGraphVisitor artifactsGraphVisitor = this.artifactVisitorFor(artifactsBuilder, immutableArtifactTypeRegistry);
        ImmutableList visitors = ImmutableList.of((Object)failureCollector, (Object)resolutionResultBuilder, (Object)localComponentsVisitor, (Object)artifactsGraphVisitor);
        this.doResolve(resolveContext, rootComponent, resolutionStrategy, resolvers, false, IS_LOCAL_EDGE, (ImmutableList<DependencyGraphVisitor>)visitors);
        localComponentsVisitor.complete(ConfigurationInternal.InternalState.BUILD_DEPENDENCIES_RESOLVED);
        Set<UnresolvedDependency> unresolvedDependencies = failureCollector.complete(Collections.emptySet());
        DefaultVisitedGraphResults graphResults = new DefaultVisitedGraphResults(resolutionResultBuilder.getResolutionResult(), unresolvedDependencies, null);
        VisitedArtifactResults artifactsResults = artifactsBuilder.complete();
        TransformUpstreamDependenciesResolver.Factory dependenciesResolverFactory = visitedArtifacts -> new DefaultTransformUpstreamDependenciesResolver(resolutionHost, configurationIdentity, requestAttributes, defaultSortOrder, graphResults, visitedArtifacts, futureCompleteResults, this.domainObjectContext, this.calculatedValueContainerFactory, this.attributesFactory, this.taskDependencyFactory);
        VisitedArtifactSet visitedArtifacts2 = this.getVisitedArtifactSet(graphResults, resolutionHost, consumerSchema, artifactsResults, resolvers, dependenciesResolverFactory, immutableArtifactTypeRegistry);
        ResolverResults.LegacyResolverResults legacyResolverResults = DefaultResolverResults.DefaultLegacyResolverResults.buildDependenciesResolved(dependencySpec -> visitedArtifacts2.select(ResolutionExecutor.getImplicitSelectionSpec(requestAttributes, defaultSortOrder)));
        return DefaultResolverResults.buildDependenciesResolved(graphResults, visitedArtifacts2, legacyResolverResults);
    }

    public ResolverResults resolveGraph(ResolveContext resolveContext, List<ResolutionAwareRepository> repositories) {
        Set<Conflict> versionConflicts;
        ResolutionHost resolutionHost = resolveContext.getResolutionHost();
        RootComponentMetadataBuilder.RootComponentState rootComponent = resolveContext.toRootComponent();
        ImmutableAttributes requestAttributes = rootComponent.getRootVariant().getAttributes();
        ResolutionStrategy.SortOrder defaultSortOrder = resolveContext.getResolutionStrategy().getSortOrder();
        ImmutableAttributesSchema consumerSchema = rootComponent.getRootComponent().getMetadata().getAttributesSchema();
        ConfigurationIdentity configurationIdentity = resolveContext.getConfigurationIdentity();
        StoreSet stores = this.storeFactory.createStoreSet();
        BinaryStore oldModelStore = stores.nextBinaryStore();
        Store<TransientConfigurationResults> oldModelCache = stores.oldModelCache();
        TransientConfigurationResultsBuilder oldTransientModelBuilder = new TransientConfigurationResultsBuilder(oldModelStore, oldModelCache, this.moduleIdentifierFactory, this.buildOperationExecutor, resolutionHost);
        DefaultResolvedConfigurationBuilder oldModelBuilder = new DefaultResolvedConfigurationBuilder(oldTransientModelBuilder);
        ResolvedConfigurationDependencyGraphVisitor oldModelVisitor = new ResolvedConfigurationDependencyGraphVisitor(oldModelBuilder);
        BinaryStore newModelStore = stores.nextBinaryStore();
        Store<ResolvedComponentResultInternal> newModelCache = stores.newModelCache();
        ResolutionStrategyInternal resolutionStrategy = resolveContext.getResolutionStrategy();
        StreamingResolutionResultBuilder newModelBuilder = new StreamingResolutionResultBuilder(newModelStore, newModelCache, this.attributeContainerSerializer, this.capabilitySelectorSerializer, this.componentResultSerializer, this.componentSelectionDescriptorFactory, resolutionStrategy.getIncludeAllSelectableVariantResults());
        ResolvedLocalComponentsResultGraphVisitor localComponentsVisitor = new ResolvedLocalComponentsResultGraphVisitor(this.currentBuild, this.projectStateRegistry);
        DefaultResolvedArtifactsBuilder artifactsBuilder = new DefaultResolvedArtifactsBuilder(this.buildProjectDependencies);
        FileDependencyCollectingGraphVisitor fileDependencyVisitor = new FileDependencyCollectingGraphVisitor();
        ResolutionFailureCollector failureCollector = new ResolutionFailureCollector(this.componentSelectorConverter);
        ImmutableList.Builder graphVisitors = ImmutableList.builder();
        graphVisitors.add((Object)newModelBuilder);
        graphVisitors.add((Object)localComponentsVisitor);
        graphVisitors.add((Object)failureCollector);
        FailOnVersionConflictGraphVisitor versionConflictVisitor = null;
        if (resolutionStrategy.getConflictResolution() == ConflictResolution.strict) {
            versionConflictVisitor = new FailOnVersionConflictGraphVisitor();
            graphVisitors.add((Object)versionConflictVisitor);
        }
        DependencyLockingGraphVisitor lockingVisitor = null;
        if (resolutionStrategy.isDependencyLockingEnabled()) {
            lockingVisitor = new DependencyLockingGraphVisitor(resolveContext.getDependencyLockingId(), resolutionHost.displayName(), this.dependencyLockingProvider);
            graphVisitors.add((Object)lockingVisitor);
        } else {
            this.dependencyLockingProvider.confirmNotLocked(resolveContext.getDependencyLockingId());
        }
        ComponentResolvers resolvers = this.getResolvers(resolveContext, repositories, consumerSchema, (AttributeContainerInternal)requestAttributes);
        CompositeDependencyArtifactsVisitor artifactVisitors = new CompositeDependencyArtifactsVisitor((List<DependencyArtifactsVisitor>)ImmutableList.of((Object)oldModelVisitor, (Object)fileDependencyVisitor, (Object)artifactsBuilder));
        ImmutableArtifactTypeRegistry immutableArtifactTypeRegistry = this.attributeSchemaServices.getArtifactTypeRegistryFactory().create(this.artifactTypeRegistry);
        graphVisitors.add((Object)this.artifactVisitorFor(artifactVisitors, immutableArtifactTypeRegistry));
        this.doResolve(resolveContext, rootComponent, resolutionStrategy, resolvers, true, (Spec<DependencyMetadata>)Specs.satisfyAll(), (ImmutableList<DependencyGraphVisitor>)graphVisitors.build());
        localComponentsVisitor.complete(ConfigurationInternal.InternalState.GRAPH_RESOLVED);
        VisitedArtifactResults artifactsResults = artifactsBuilder.complete();
        VisitedFileDependencyResults fileDependencyResults = fileDependencyVisitor.complete();
        ResolvedGraphResults legacyGraphResults = oldModelBuilder.complete();
        Set<UnresolvedDependency> lockingFailures = Collections.emptySet();
        ImmutableSet.Builder nonFatalFailuresBuilder = ImmutableSet.builder();
        if (lockingVisitor != null) {
            lockingFailures = lockingVisitor.collectLockingFailures();
        }
        if (versionConflictVisitor != null && !(versionConflicts = versionConflictVisitor.getAllConflicts()).isEmpty()) {
            List<String> resolutions = resolveContext.getFailureResolutions().forVersionConflict(versionConflicts);
            nonFatalFailuresBuilder.add((Object)new VersionConflictException(versionConflicts, resolutions));
        }
        ImmutableSet nonFatalFailures = nonFatalFailuresBuilder.build();
        Set<UnresolvedDependency> resolutionFailures = failureCollector.complete(lockingFailures);
        MinimalResolutionResult resolutionResult = newModelBuilder.getResolutionResult(lockingFailures);
        Optional<TypedResolveException> failure = resolutionHost.consolidateFailures("dependencies", (Collection<Throwable>)nonFatalFailures);
        DefaultVisitedGraphResults graphResults = new DefaultVisitedGraphResults(resolutionResult, resolutionFailures, failure.orElse(null));
        if (lockingVisitor != null && !graphResults.hasAnyFailure()) {
            lockingVisitor.writeLocks();
        }
        TransformUpstreamDependenciesResolver.Factory dependenciesResolverFactory = visitedArtifacts -> new DefaultTransformUpstreamDependenciesResolver(resolutionHost, configurationIdentity, requestAttributes, defaultSortOrder, graphResults, visitedArtifacts, this.domainObjectContext, this.calculatedValueContainerFactory, this.attributesFactory, this.taskDependencyFactory);
        VisitedArtifactSet visitedArtifacts2 = this.getVisitedArtifactSet(graphResults, resolutionHost, consumerSchema, artifactsResults, resolvers, dependenciesResolverFactory, immutableArtifactTypeRegistry);
        TransientConfigurationResultsLoader transientConfigurationResultsFactory = new TransientConfigurationResultsLoader(oldTransientModelBuilder, legacyGraphResults);
        DefaultLenientConfiguration lenientConfiguration = new DefaultLenientConfiguration(resolutionHost, graphResults, visitedArtifacts2, fileDependencyResults, transientConfigurationResultsFactory, this.artifactSetResolver, ResolutionExecutor.getImplicitSelectionSpec(requestAttributes, defaultSortOrder));
        ResolverResults.LegacyResolverResults legacyResolverResults = DefaultResolverResults.DefaultLegacyResolverResults.graphResolved(lenientConfiguration, new DefaultResolvedConfiguration(graphResults, resolutionHost, visitedArtifacts2, lenientConfiguration));
        return DefaultResolverResults.graphResolved(graphResults, visitedArtifacts2, legacyResolverResults);
    }

    private static ArtifactSelectionSpec getImplicitSelectionSpec(ImmutableAttributes requestAttributes, ResolutionStrategy.SortOrder sortOrder) {
        return new ArtifactSelectionSpec(requestAttributes, (Spec<? super ComponentIdentifier>)Specs.satisfyAll(), false, false, sortOrder);
    }

    private ResolvedArtifactsGraphVisitor artifactVisitorFor(DependencyArtifactsVisitor artifactsVisitor, ImmutableArtifactTypeRegistry immutableArtifactTypeRegistry) {
        return new ResolvedArtifactsGraphVisitor(artifactsVisitor, immutableArtifactTypeRegistry, this.variantArtifactSetCache, this.calculatedValueContainerFactory);
    }

    private VisitedArtifactSet getVisitedArtifactSet(VisitedGraphResults graphResults, ResolutionHost resolutionHost, ImmutableAttributesSchema consumerSchema, VisitedArtifactResults artifactsResults, ComponentResolvers resolvers, TransformUpstreamDependenciesResolver.Factory dependenciesResolverFactory, ImmutableArtifactTypeRegistry immutableArtifactTypeRegistry) {
        return new DefaultVisitedArtifactSet(graphResults, resolutionHost, artifactsResults, this.artifactSetResolver, this.transformedVariantFactory, dependenciesResolverFactory, consumerSchema, this.consumerProvidedVariantFinder, this.attributesFactory, this.attributeSchemaServices, this.resolutionFailureHandler, resolvers.getArtifactResolver(), immutableArtifactTypeRegistry, this.resolvedVariantCache, this.graphVariantSelector, this.transformRegistry);
    }

    private void doResolve(ResolveContext resolveContext, RootComponentMetadataBuilder.RootComponentState rootComponent, ResolutionStrategyInternal resolutionStrategy, ComponentResolvers resolvers, boolean includeSyntheticDependencies, Spec<DependencyMetadata> edgeFilter, ImmutableList<DependencyGraphVisitor> visitors) {
        if (resolutionStrategy.isDependencyLockingEnabled()) {
            if (resolutionStrategy.isFailingOnDynamicVersions()) {
                throw new InvalidUserCodeException("Both dependency locking and fail on dynamic versions are enabled. You must choose between the two modes.");
            }
            if (resolutionStrategy.isFailingOnChangingVersions()) {
                throw new InvalidUserCodeException("Both dependency locking and fail on changing versions are enabled. You must choose between the two modes.");
            }
        }
        List<Object> syntheticDependencies = includeSyntheticDependencies ? resolveContext.getSyntheticDependencies() : Collections.emptyList();
        this.dependencyGraphResolver.resolve(rootComponent, syntheticDependencies, edgeFilter, this.componentSelectorConverter, resolvers.getComponentIdResolver(), resolvers.getComponentResolver(), this.metadataHandler.getModuleMetadataProcessor().getModuleReplacements(), resolutionStrategy.getDependencySubstitutionRule(), resolutionStrategy.getConflictResolution(), resolutionStrategy.getCapabilitiesResolutionRules(), resolutionStrategy.isFailingOnDynamicVersions(), resolutionStrategy.isFailingOnChangingVersions(), new CompositeDependencyGraphVisitor((List<DependencyGraphVisitor>)visitors));
    }

    private ComponentResolvers getResolvers(ResolveContext resolveContext, List<ResolutionAwareRepository> repositories, ImmutableAttributesSchema consumerSchema, AttributeContainerInternal requestAttributes) {
        ArrayList<ComponentResolvers> resolvers = new ArrayList<ComponentResolvers>(3);
        for (ResolverProviderFactory factory : this.resolverFactories) {
            factory.create(resolvers, this.localComponentRegistry);
        }
        resolvers.add(this.projectDependencyResolver);
        ResolutionStrategyInternal resolutionStrategy = resolveContext.getResolutionStrategy();
        resolvers.add(this.externalResolverFactory.createResolvers(repositories, this.metadataHandler.getComponentMetadataProcessorFactory(), resolutionStrategy.getComponentSelection(), resolutionStrategy.isDependencyVerificationEnabled(), resolutionStrategy.getCachePolicy(), (AttributeContainer)requestAttributes, consumerSchema));
        return new ComponentResolversChain(resolvers);
    }
}

