/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.sshd;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import org.eclipse.jgit.annotations.NonNull;

public class ProxyData {
    @NonNull
    private final Proxy proxy;
    private final String proxyUser;
    private final char[] proxyPassword;

    public ProxyData(@NonNull Proxy proxy) {
        this(proxy, null, null);
    }

    public ProxyData(@NonNull Proxy proxy, String proxyUser, char[] proxyPassword) {
        this.proxy = proxy;
        if (!(proxy.address() instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Proxy does not have an InetSocketAddress");
        }
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword == null ? null : (char[])proxyPassword.clone();
    }

    @NonNull
    public Proxy getProxy() {
        return this.proxy;
    }

    public String getUser() {
        return this.proxyUser;
    }

    public char[] getPassword() {
        return this.proxyPassword == null ? null : (char[])this.proxyPassword.clone();
    }

    public void clearPassword() {
        if (this.proxyPassword != null) {
            Arrays.fill(this.proxyPassword, '\u0000');
        }
    }
}

