/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.launcher.cli.converter.BuildLayoutConverter;
import org.gradle.launcher.daemon.client.DaemonStartListener;
import org.gradle.launcher.daemon.client.DaemonStopClientExecuter;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;
import org.gradle.launcher.daemon.registry.DaemonDir;

@ServiceScope(value={Scope.Global.class})
public class ShutdownCoordinator
implements DaemonStartListener,
Stoppable {
    private final Map<File, Set<DaemonConnectDetails>> daemons = new HashMap<File, Set<DaemonConnectDetails>>();
    private final DaemonStopClientExecuter client;
    private final File incorrectDaemonRegistryPath;

    public ShutdownCoordinator(DaemonStopClientExecuter client) {
        this.client = client;
        this.incorrectDaemonRegistryPath = new DaemonParameters(new BuildLayoutConverter().defaultValues().getGradleUserHomeDir(), null).getBaseDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void daemonStarted(DaemonDir daemonDir, DaemonConnectDetails daemon) {
        Map<File, Set<DaemonConnectDetails>> map = this.daemons;
        synchronized (map) {
            Set<Object> startedDaemons;
            if (!this.daemons.containsKey(daemonDir.getBaseDir())) {
                startedDaemons = new HashSet();
                this.daemons.put(daemonDir.getBaseDir(), startedDaemons);
            } else {
                startedDaemons = this.daemons.get(daemonDir.getBaseDir());
            }
            startedDaemons.add(daemon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStartedDaemons(ServiceRegistry requestSpecificLoggingServices, File daemonBaseDir) {
        Map<File, Set<DaemonConnectDetails>> map = this.daemons;
        synchronized (map) {
            Set<DaemonConnectDetails> startedDaemons = this.daemons.get(daemonBaseDir);
            if (startedDaemons != null && !startedDaemons.isEmpty()) {
                try {
                    this.client.execute(requestSpecificLoggingServices, daemonBaseDir, daemonStopClient -> daemonStopClient.gracefulStop((Collection)startedDaemons));
                }
                finally {
                    startedDaemons.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ServiceRegistry requestSpecificLoggingServices = LoggingServiceRegistry.newNestedLogging();
        Map<File, Set<DaemonConnectDetails>> map = this.daemons;
        synchronized (map) {
            for (Set<DaemonConnectDetails> startedDaemons : this.daemons.values()) {
                try {
                    this.client.execute(requestSpecificLoggingServices, this.incorrectDaemonRegistryPath, daemonStopClient -> daemonStopClient.gracefulStop((Collection)startedDaemons));
                }
                finally {
                    startedDaemons.clear();
                }
            }
        }
    }
}

