/*
 * Decompiled with CFR 0.152.
 */
import com.google.gerrit.launcher.GerritLauncher;

public final class Main {
    private static final String FLOGGER_BACKEND_PROPERTY = "flogger.backend_factory";
    private static final String FLOGGER_LOGGING_CONTEXT = "flogger.logging_context";

    public static void main(String[] argv) throws Exception {
        if (Main.onSupportedJavaVersion()) {
            Main.configureFloggerBackend();
            GerritLauncher.main(argv);
        } else {
            System.exit(1);
        }
    }

    private static boolean onSupportedJavaVersion() {
        String version = System.getProperty("java.specification.version");
        if (1.8 <= Main.parse(version)) {
            return true;
        }
        System.err.println("fatal: Gerrit Code Review requires Java 8 or later");
        System.err.println("       (trying to run on Java " + version + ")");
        return false;
    }

    private static void configureFloggerBackend() {
        System.setProperty(FLOGGER_LOGGING_CONTEXT, "com.google.gerrit.server.logging.LoggingContext#getInstance");
        if (System.getProperty(FLOGGER_BACKEND_PROPERTY) != null) {
            return;
        }
        System.setProperty(FLOGGER_BACKEND_PROPERTY, "com.google.common.flogger.backend.log4j.Log4jBackendFactory#getInstance");
    }

    private static double parse(String version) {
        if (version == null || version.length() == 0) {
            return 0.0;
        }
        try {
            int fd = version.indexOf(46);
            int sd = version.indexOf(46, fd + 1);
            if (0 < sd) {
                version = version.substring(0, sd);
            }
            return Double.parseDouble(version);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private Main() {
    }
}

