/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.ic.ICHash;
import org.jetbrains.kotlin.ir.backend.js.ic.ImportedSignaturesState;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileMap;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileMetadata;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileMetadataKt;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileMutableMap;
import org.jetbrains.kotlin.ir.util.IdSignature;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0006\u0010\u001d\u001a\u00020\u001eR\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R&\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/UpdatedDependenciesMetadata;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMetadata;", "oldMetadata", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMetadata;)V", "oldInverseDependencies", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMap;", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "newExportedSignatures", "getNewExportedSignatures", "()Ljava/util/Set;", "newExportedSignatures$delegate", "Lkotlin/Lazy;", "importedSignaturesState", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ImportedSignaturesState;", "getImportedSignaturesState", "()Lorg/jetbrains/kotlin/ir/backend/js/ic/ImportedSignaturesState;", "setImportedSignaturesState", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/ImportedSignaturesState;)V", "inverseDependencies", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMutableMap;", "getInverseDependencies", "()Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMutableMap;", "directDependencies", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ICHash;", "getDirectDependencies", "getExportedSignatures", "isExportedSignaturesUpdated", "", "backend.js"})
public final class UpdatedDependenciesMetadata
extends KotlinSourceFileMetadata {
    @NotNull
    private final KotlinSourceFileMap<Set<IdSignature>> oldInverseDependencies;
    @NotNull
    private final Lazy newExportedSignatures$delegate;
    @NotNull
    private ImportedSignaturesState importedSignaturesState;
    @NotNull
    private final KotlinSourceFileMutableMap<Set<IdSignature>> inverseDependencies;
    @NotNull
    private final KotlinSourceFileMutableMap<Map<IdSignature, ICHash>> directDependencies;

    public UpdatedDependenciesMetadata(@NotNull KotlinSourceFileMetadata oldMetadata) {
        Intrinsics.checkNotNullParameter(oldMetadata, "oldMetadata");
        this.oldInverseDependencies = oldMetadata.getInverseDependencies();
        this.newExportedSignatures$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> UpdatedDependenciesMetadata.newExportedSignatures_delegate$lambda$0(this));
        this.importedSignaturesState = ImportedSignaturesState.UNKNOWN;
        this.inverseDependencies = KotlinSourceFileMetadataKt.toMutable(oldMetadata.getInverseDependencies());
        this.directDependencies = KotlinSourceFileMetadataKt.toMutable(oldMetadata.getDirectDependencies());
    }

    private final Set<IdSignature> getNewExportedSignatures() {
        Lazy lazy = this.newExportedSignatures$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final ImportedSignaturesState getImportedSignaturesState() {
        return this.importedSignaturesState;
    }

    public final void setImportedSignaturesState(@NotNull ImportedSignaturesState importedSignaturesState) {
        Intrinsics.checkNotNullParameter((Object)importedSignaturesState, "<set-?>");
        this.importedSignaturesState = importedSignaturesState;
    }

    @NotNull
    public KotlinSourceFileMutableMap<Set<IdSignature>> getInverseDependencies() {
        return this.inverseDependencies;
    }

    @NotNull
    public KotlinSourceFileMutableMap<Map<IdSignature, ICHash>> getDirectDependencies() {
        return this.directDependencies;
    }

    @Override
    @NotNull
    public Set<IdSignature> getExportedSignatures() {
        return this.getNewExportedSignatures();
    }

    public final boolean isExportedSignaturesUpdated() {
        return !Intrinsics.areEqual(this.getNewExportedSignatures(), KotlinSourceFileMetadataKt.flatSignatures(this.oldInverseDependencies));
    }

    private static final Set newExportedSignatures_delegate$lambda$0(UpdatedDependenciesMetadata this$0) {
        return KotlinSourceFileMetadataKt.flatSignatures(this$0.getInverseDependencies());
    }
}

