/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waiter;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public interface WaiterScheduler {
    public static final WaiterScheduler UNSUPPORTED = new WaiterScheduler(){

        @Override
        public Future<?> schedule(Runnable command, long time, TimeUnit unit) {
            throw new UnsupportedOperationException("Delays not supported for async waiter (no scheduler given)");
        }
    };
    public static final WaiterScheduler SYNC = new WaiterScheduler(){
        private final Future<?> completed = CompletableFuture.completedFuture(null);

        @Override
        public Future<?> schedule(Runnable command, long time, TimeUnit unit) {
            try {
                unit.sleep(time);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            command.run();
            return this.completed;
        }
    };

    public static WaiterScheduler fromService(ScheduledExecutorService service) {
        return service::schedule;
    }

    public Future<?> schedule(Runnable var1, long var2, TimeUnit var4);
}

