/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermCollection;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.reader.DitamapIndexTermReader;
import org.dita.dost.reader.IndexTermReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.xml.sax.SAXException;

public class IndexTermExtractModule
extends AbstractPipelineModuleImpl {
    private File inputMap = null;
    private String targetExt = null;
    private List<URI> topicList = null;
    private List<URI> ditamapList = null;
    private IndexTermCollection indexTermCollection;

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        this.indexTermCollection = new IndexTermCollection();
        this.indexTermCollection.setLogger(this.logger);
        try {
            this.parseAndValidateInput(input);
            this.extractIndexTerm();
            this.indexTermCollection.sort();
            this.indexTermCollection.outputTerms();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        return null;
    }

    private void parseAndValidateInput(AbstractPipelineInput input) {
        String baseDir = input.getAttribute("basedir");
        String output = input.getAttribute("output");
        if (!new File(output).isAbsolute()) {
            output = new File(baseDir, output).getAbsolutePath();
        }
        String encoding = input.getAttribute("encoding");
        String indextype = input.getAttribute("indextype");
        String indexclass = input.getAttribute("indexclass");
        Job.FileInfo in = this.job.getFileInfo(fi -> fi.isInput).iterator().next();
        this.inputMap = new File(this.job.tempDirURI.resolve(in.uri));
        this.targetExt = input.getAttribute("targetext");
        this.topicList = new ArrayList<URI>();
        for (Job.FileInfo f : this.job.getFileInfo()) {
            if (!"dita".equals(f.format) || f.isResourceOnly) continue;
            this.topicList.add(this.job.tempDirURI.resolve(f.uri));
        }
        this.ditamapList = new ArrayList<URI>();
        for (Job.FileInfo f : this.job.getFileInfo()) {
            if (!"ditamap".equals(f.format) || f.isResourceOnly) continue;
            this.ditamapList.add(this.job.tempDirURI.resolve(f.uri));
        }
        int lastIndexOfDot = output.lastIndexOf(".");
        String outputRoot = lastIndexOfDot == -1 ? output : output.substring(0, lastIndexOfDot);
        this.indexTermCollection.setOutputFileRoot(outputRoot);
        this.indexTermCollection.setIndexType(indextype);
        this.indexTermCollection.setIndexClass(indexclass);
        this.indexTermCollection.setPipelineHashIO((PipelineHashIO)input);
        if (encoding != null && encoding.trim().length() > 0) {
            IndexTerm.setTermLocale(StringUtils.getLocale(encoding));
        }
    }

    private void extractIndexTerm() throws SAXException {
        IndexTermReader handler = new IndexTermReader(this.indexTermCollection);
        handler.setLogger(this.logger);
        DitamapIndexTermReader ditamapIndexTermReader = new DitamapIndexTermReader(this.indexTermCollection, true);
        ditamapIndexTermReader.setLogger(this.logger);
        Job.FileInfo fileInfo = this.job.getFileInfo(f -> f.isInput).iterator().next();
        URI tempInputMap = this.job.tempDirURI.resolve(fileInfo.uri);
        for (URI aTopicList : this.topicList) {
            handler.reset();
            URI target = aTopicList;
            String targetPathFromMap = FileUtils.getRelativeUnixPath(tempInputMap.toString(), target.toString());
            String targetPathFromMapWithoutExt = targetPathFromMap.substring(0, targetPathFromMap.lastIndexOf("."));
            handler.setTargetFile(targetPathFromMapWithoutExt + this.targetExt);
            try {
                this.job.getStore().transform(target, handler);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                StringBuilder buff = new StringBuilder();
                String msg = MessageUtils.getMessage("DOTJ013E", target.toString()).toString();
                this.logger.error(buff.append(msg).append(e.getMessage()).toString());
            }
        }
        for (URI ditamap : this.ditamapList) {
            String currentMapPathName = FileUtils.getRelativeUnixPath(tempInputMap.toString(), ditamap.toString());
            String mapPathFromInputMap = "";
            if (currentMapPathName.lastIndexOf("/") != -1) {
                mapPathFromInputMap = currentMapPathName.substring(0, currentMapPathName.lastIndexOf("/"));
            }
            ditamapIndexTermReader.setMapPath(mapPathFromInputMap);
            try {
                this.job.getStore().transform(ditamap, ditamapIndexTermReader);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = MessageUtils.getMessage("DOTJ013E", ditamap.toString()).toString();
                this.logger.error(msg, e);
            }
        }
    }
}

