/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.groovysh.jline;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.IntBinaryOperator;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.runtime.ArrayGroovyMethods;
import org.jline.builtins.Less;
import org.jline.builtins.Options;
import org.jline.builtins.PosixCommands;
import org.jline.builtins.Source;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.OSUtils;

public class GroovyPosixCommands
extends PosixCommands {
    private static final LinkOption[] NO_FOLLOW_OPTIONS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    private static final LinkOption[] EMPTY_LINK_OPTIONS = new LinkOption[0];
    private static final List<String> WINDOWS_EXECUTABLE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(".bat", ".exe", ".cmd"));

    public static void cat(PosixCommands.Context context, Object[] argv) throws Exception {
        String[] usage = new String[]{"/cat - concatenate and print FILES or VARIABLES", "Usage: /cat [OPTIONS] [FILES] [VARIABLES]", "  -? --help                show help", "  -n                       number the output lines, starting at 1"};
        Options opt = GroovyPosixCommands.parseOptions((PosixCommands.Context)context, (String[])usage, (Object[])argv);
        List<String> args = opt.args();
        if (args.isEmpty()) {
            args = Collections.singletonList("-");
        }
        List<NamedInputStream> sources = GroovyPosixCommands.getSources(context, argv, args);
        for (NamedInputStream nis : sources) {
            InputStream is = nis.getInputStream();
            GroovyPosixCommands.doCat(context, new BufferedReader((Reader)new org.jline.utils.InputStreamReader(is)), opt.isSet("n"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCat(PosixCommands.Context context, BufferedReader reader, boolean numbered) throws IOException {
        int lineno = 1;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (numbered) {
                    context.out().printf("%6d\t%s%n", lineno++, line);
                    continue;
                }
                context.out().println(line);
            }
        }
        finally {
            reader.close();
        }
    }

    public static void wc(PosixCommands.Context context, Object[] argv) throws Exception {
        String totalOpt;
        String[] usage = new String[]{"/wc - word, line, character, and byte count", "Usage: /wc [OPTIONS] [FILES]", "  -? --help                    Show help", "  -l --lines                   Print line counts", "  -c --bytes                   Print byte counts", "  -m --chars                   Print character counts", "  -w --words                   Print word counts", "     --total=WHEN              Print total counts, WHEN=auto|always|never|only"};
        Options opt = GroovyPosixCommands.parseOptions((PosixCommands.Context)context, (String[])usage, (Object[])argv);
        List<String> args = opt.args();
        if (args.isEmpty()) {
            args = Collections.singletonList("-");
        }
        List<NamedInputStream> sources = GroovyPosixCommands.getSources(context, argv, args);
        boolean showLines = opt.isSet("lines");
        boolean showWords = opt.isSet("words");
        boolean showChars = opt.isSet("chars");
        boolean showBytes = opt.isSet("bytes");
        boolean only = false;
        boolean total = sources.size() > 1;
        switch (totalOpt = opt.isSet("total") ? opt.get("total") : "auto") {
            case "always": 
            case "yes": 
            case "force": {
                total = true;
                break;
            }
            case "never": 
            case "no": 
            case "none": {
                total = false;
                break;
            }
            case "only": {
                only = true;
                break;
            }
            case "auto": 
            case "tty": 
            case "if-tty": {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid argument '" + totalOpt + "' for '--total'");
            }
        }
        if (!(showLines || showWords || showChars || showBytes)) {
            showBytes = true;
            showWords = true;
            showLines = true;
        }
        long totalLines = 0L;
        long totalWords = 0L;
        long totalChars = 0L;
        long totalBytes = 0L;
        for (NamedInputStream source : sources) {
            long lines = 0L;
            long words = 0L;
            long chars = 0L;
            long bytes = 0L;
            try (BufferedReader reader = new BufferedReader((Reader)new org.jline.utils.InputStreamReader(source.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    ++lines;
                    chars += (long)(line.length() + 1);
                    bytes += (long)(line.getBytes().length + 1);
                    String[] wordArray = line.trim().split("\\s+");
                    if (wordArray.length == 1 && wordArray[0].isEmpty()) continue;
                    words += (long)wordArray.length;
                }
            }
            totalLines += lines;
            totalWords += words;
            totalChars += chars;
            totalBytes += bytes;
            if (only) continue;
            StringBuilder result = new StringBuilder();
            if (showLines) {
                result.append(String.format("%8d", lines));
            }
            if (showWords) {
                result.append(String.format("%8d", words));
            }
            if (showChars) {
                result.append(String.format("%8d", chars));
            }
            if (showBytes) {
                result.append(String.format("%8d", bytes));
            }
            result.append(" ").append(source.getName());
            context.out().println(result);
            context.out().flush();
        }
        if (total) {
            StringBuilder result = new StringBuilder();
            if (showLines) {
                result.append(String.format("%8d", totalLines));
            }
            if (showWords) {
                result.append(String.format("%8d", totalWords));
            }
            if (showChars) {
                result.append(String.format("%8d", totalChars));
            }
            if (showBytes) {
                result.append(String.format("%8d", totalBytes));
            }
            result.append(" total");
            context.out().println(result);
        }
    }

    public static void head(PosixCommands.Context context, Object[] argv) throws Exception {
        String[] usage = new String[]{"/head - display first lines of files or variables", "Usage: /head [-n lines | -c bytes] [-q | -v] [file|variable ...]", "  -? --help                    Show help", "  -n --lines=LINES             Print line counts", "  -c --bytes=BYTES             Print byte counts", "  -q --quiet                   Never output filename headers", "  -v --verbose                 Always output filename headers"};
        Options opt = GroovyPosixCommands.parseOptions((PosixCommands.Context)context, (String[])usage, (Object[])argv);
        if (opt.isSet("lines") && opt.isSet("bytes")) {
            throw new IllegalArgumentException("usage: /head [-n # | -c #] [-q | -v] [file|variable ...]");
        }
        if (opt.isSet("quiet") && opt.isSet("verbose")) {
            throw new IllegalArgumentException("usage: /head [-n # | -c #] [-q | -v] [file|variable ...]");
        }
        int nbLines = Integer.MAX_VALUE;
        int nbBytes = Integer.MAX_VALUE;
        if (opt.isSet("lines")) {
            nbLines = opt.getNumber("lines");
        } else if (opt.isSet("bytes")) {
            nbBytes = opt.getNumber("bytes");
        } else {
            nbLines = 10;
        }
        List<String> args = opt.args();
        if (args.isEmpty()) {
            args = Collections.singletonList("-");
        }
        boolean first = true;
        List<NamedInputStream> sources = GroovyPosixCommands.getSources(context, argv, args);
        for (NamedInputStream nis : sources) {
            boolean filenameHeader;
            boolean bl = filenameHeader = sources.size() > 1;
            if (opt.isSet("verbose")) {
                filenameHeader = true;
            } else if (opt.isSet("quiet")) {
                filenameHeader = false;
            }
            if (filenameHeader) {
                if (!first) {
                    context.out().println();
                }
                context.out().println("==> " + nis.getName() + " <==");
            }
            GroovyPosixCommands.doHead(context, nis.getInputStream(), nbLines, nbBytes);
            first = false;
        }
    }

    private static void doHead(PosixCommands.Context context, InputStream is, int nbLines, int nbBytes) throws IOException {
        if (nbLines != Integer.MAX_VALUE) {
            try (BufferedReader reader = new BufferedReader((Reader)new org.jline.utils.InputStreamReader(is));){
                String line;
                for (int count = 0; (line = reader.readLine()) != null && count < nbLines; ++count) {
                    context.out().println(line);
                }
            }
        } else {
            byte[] buffer = new byte[nbBytes];
            int bytesRead = is.read(buffer);
            if (bytesRead > 0) {
                context.out().write(buffer, 0, bytesRead);
            }
            is.close();
        }
    }

    public static void tail(PosixCommands.Context context, Object[] argv) throws Exception {
        List<NamedInputStream> sources;
        boolean filenameHeader;
        String[] usage = new String[]{"/tail - display last lines of files or variables", "Usage: /tail [-n lines | -c bytes] [-q | -v] [file|variable ...]", "  -? --help                    Show help", "  -n --lines=LINES             Number of lines to print", "  -c --bytes=BYTES             Number of bytes to print", "  -q --quiet                   Never output filename headers", "  -v --verbose                 Always output filename headers"};
        Options opt = GroovyPosixCommands.parseOptions((PosixCommands.Context)context, (String[])usage, (Object[])argv);
        if (opt.isSet("lines") && opt.isSet("bytes")) {
            throw new IllegalArgumentException("usage: /tail [-c # | -n #] [-q | -v] [file|variable ...]");
        }
        if (opt.isSet("quiet") && opt.isSet("verbose")) {
            throw new IllegalArgumentException("usage: /tail [-c # | -n #] [-q | -v] [file|variable ...]");
        }
        int lines = opt.isSet("lines") ? opt.getNumber("lines") : 10;
        int bytes = opt.isSet("bytes") ? opt.getNumber("bytes") : -1;
        List<String> args = opt.args();
        if (args.isEmpty()) {
            args = Collections.singletonList("-");
        }
        boolean bl = filenameHeader = (sources = GroovyPosixCommands.getSources(context, argv, args)).size() > 1;
        if (opt.isSet("verbose")) {
            filenameHeader = true;
        } else if (opt.isSet("quiet")) {
            filenameHeader = false;
        }
        for (NamedInputStream nis : sources) {
            if (filenameHeader) {
                context.out().println("==> " + nis.getName() + " <==");
            }
            GroovyPosixCommands.tailInputStream(context, nis.getInputStream(), lines, bytes);
        }
    }

    private static void tailInputStream(PosixCommands.Context context, InputStream is, int lines, int bytes) throws IOException {
        if (bytes > 0) {
            int n;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((n = is.read(buffer)) != -1) {
                baos.write(buffer, 0, n);
            }
            byte[] data = baos.toByteArray();
            int start = Math.max(0, data.length - bytes);
            context.out().write(data, start, data.length - start);
        } else {
            int start;
            ArrayList<String> allLines = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = reader.readLine()) != null) {
                    allLines.add(line);
                }
            }
            for (int i = start = Math.max(0, allLines.size() - lines); i < allLines.size(); ++i) {
                context.out().println((String)allLines.get(i));
            }
        }
    }

    public static void ls(PosixCommands.Context context, Object[] argv) throws Exception {
        class PathEntry
        implements Comparable<PathEntry> {
            final Path abs;
            final Path path;
            final Map<String, Object> attributes;

            public PathEntry(Path abs, Path root) {
                this.abs = abs;
                this.path = this.getPath(abs, root);
                this.attributes = this.readAttributes(abs);
            }

            private Path getPath(Path abs, Path root) {
                try {
                    return Files.isSameFile(abs, root) ? Paths.get(".", new String[0]) : (abs.startsWith(root) ? root.relativize(abs) : abs);
                }
                catch (IOException ignore) {
                    return abs;
                }
            }

            @Override
            public int compareTo(PathEntry o) {
                int c = this.doCompare(o);
                return opt.isSet("r") ? -c : c;
            }

            private int doCompare(PathEntry o) {
                if (opt.isSet("f")) {
                    return -1;
                }
                if (opt.isSet("S")) {
                    long s1;
                    long s0 = this.attributes.get("size") != null ? ((Number)this.attributes.get("size")).longValue() : 0L;
                    long l = s1 = o.attributes.get("size") != null ? ((Number)o.attributes.get("size")).longValue() : 0L;
                    return s0 > s1 ? -1 : (s0 < s1 ? 1 : this.path.toString().compareTo(o.path.toString()));
                }
                if (opt.isSet("t")) {
                    long t1;
                    long t0 = this.attributes.get("lastModifiedTime") != null ? ((FileTime)this.attributes.get("lastModifiedTime")).toMillis() : 0L;
                    long l = t1 = o.attributes.get("lastModifiedTime") != null ? ((FileTime)o.attributes.get("lastModifiedTime")).toMillis() : 0L;
                    return t0 > t1 ? -1 : (t0 < t1 ? 1 : this.path.toString().compareTo(o.path.toString()));
                }
                return this.path.toString().compareTo(o.path.toString());
            }

            boolean isNotDirectory() {
                return this.is("isRegularFile") || this.is("isSymbolicLink") || this.is("isOther");
            }

            boolean isDirectory() {
                return this.is("isDirectory");
            }

            private boolean is(String attr) {
                Object d = this.attributes.get(attr);
                return d instanceof Boolean && (Boolean)d != false;
            }

            String display() {
                String suffix;
                String type;
                Object link = "";
                if (this.is("isSymbolicLink")) {
                    type = "sl";
                    suffix = "@";
                    try {
                        Path l = Files.readSymbolicLink(this.abs);
                        link = " -> " + l.toString();
                    }
                    catch (IOException l) {}
                } else if (this.is("isDirectory")) {
                    type = "dr";
                    suffix = "/";
                } else if (this.is("isExecutable")) {
                    type = "ex";
                    suffix = "*";
                } else if (this.is("isOther")) {
                    type = "ot";
                    suffix = "";
                } else {
                    type = "";
                    suffix = "";
                }
                boolean addSuffix = opt.isSet("F");
                return PosixCommands.applyStyle((String)this.path.toString(), (Map)colors, (String[])new String[]{type}) + (addSuffix ? suffix : "") + (String)link;
            }

            String longDisplay() {
                Object lengthString;
                StringBuilder username = this.attributes.containsKey("owner") ? new StringBuilder(Objects.toString(this.attributes.get("owner"), null)) : new StringBuilder("owner");
                if (username.length() > 8) {
                    username = new StringBuilder(username.substring(0, 8));
                } else {
                    username.append(" ".repeat(Math.max(0, 8 - username.length())));
                }
                StringBuilder group = this.attributes.containsKey("group") ? new StringBuilder(Objects.toString(this.attributes.get("group"), null)) : new StringBuilder("group");
                if (group.length() > 8) {
                    group = new StringBuilder(group.substring(0, 8));
                } else {
                    group.append(" ".repeat(Math.max(0, 8 - group.length())));
                }
                Number length = (Number)this.attributes.get("size");
                if (length == null) {
                    length = 0L;
                }
                if (opt.isSet("h")) {
                    double l = length.longValue();
                    String unit = "B";
                    if (l >= 1000.0) {
                        l /= 1024.0;
                        unit = "K";
                        if (l >= 1000.0) {
                            l /= 1024.0;
                            unit = "M";
                            if (l >= 1000.0) {
                                l /= 1024.0;
                                unit = "T";
                            }
                        }
                    }
                    lengthString = l < 10.0 && length.longValue() > 1000L ? String.format("%.1f", l) + unit : String.format("%3.0f", l) + unit;
                } else {
                    lengthString = String.format("%1$8s", length);
                }
                EnumSet<PosixFilePermission> perms = (EnumSet<PosixFilePermission>)this.attributes.get("permissions");
                if (perms == null) {
                    perms = EnumSet.noneOf(PosixFilePermission.class);
                }
                return (this.is("isDirectory") ? "d" : (this.is("isSymbolicLink") ? "l" : (this.is("isOther") ? "o" : "-"))) + PosixFilePermissions.toString(perms) + " " + String.format("%3s", this.attributes.containsKey("nlink") ? this.attributes.get("nlink").toString() : "1") + " " + username + " " + group + " " + (String)lengthString + " " + this.toString((FileTime)this.attributes.get("lastModifiedTime")) + " " + this.display();
            }

            protected String toString(FileTime time) {
                long millis;
                long l = millis = time != null ? time.toMillis() : -1L;
                if (millis < 0L) {
                    return "------------";
                }
                ZonedDateTime dt = Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault());
                if (System.currentTimeMillis() - millis < 15811200000L) {
                    return DateTimeFormatter.ofPattern("MMM ppd HH:mm").format(dt);
                }
                return DateTimeFormatter.ofPattern("MMM ppd  yyyy").format(dt);
            }

            protected Map<String, Object> readAttributes(Path path) {
                TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                for (String view : path.getFileSystem().supportedFileAttributeViews()) {
                    try {
                        Map<String, Object> ta = Files.readAttributes(path, view + ":*", GroovyPosixCommands.getLinkOptions(opt.isSet("L")));
                        ta.forEach(attrs::putIfAbsent);
                    }
                    catch (IOException iOException) {}
                }
                attrs.computeIfAbsent("isExecutable", s -> Files.isExecutable(path));
                attrs.computeIfAbsent("permissions", s -> GroovyPosixCommands.getPermissionsFromFile(path));
                return attrs;
            }
        }
        boolean colored;
        String color;
        String[] usage = new String[]{"/ls - list files", "Usage: /ls [OPTIONS] [PATTERNS...]", "  -? --help                show help", "  -1                       list one entry per line", "  -C                       multi-column output", "     --color=WHEN          colorize the output, may be `always', `never' or `auto'", "  -a                       list entries starting with .", "  -F                       append file type indicators", "  -m                       comma separated", "  -l                       long listing", "  -S                       sort by size", "  -f                       output is not sorted", "  -r                       reverse sort order", "  -t                       sort by modification time", "  -x                       sort horizontally", "  -L                       list referenced file for links", "  -h                       print sizes in human readable form"};
        final Options opt = GroovyPosixCommands.parseOptions((PosixCommands.Context)context, (String[])usage, (Object[])argv);
        Map colorMap = GroovyPosixCommands.getLsColorMap((PosixCommands.Context)context);
        switch (color = opt.isSet("color") ? opt.get("color") : "auto") {
            case "always": 
            case "yes": 
            case "force": {
                colored = true;
                break;
            }
            case "never": 
            case "no": 
            case "none": {
                colored = false;
                break;
            }
            case "auto": 
            case "tty": 
            case "if-tty": {
                colored = context.isTty();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid argument '" + color + "' for '--color'");
            }
        }
        final Map colors = colored ? (colorMap != null ? colorMap : GroovyPosixCommands.getLsColorMap((String)"dr=1;91:ex=1;92:sl=1;96:ot=34;43")) : Collections.emptyMap();
        Path currentDir = context.currentDir();
        ArrayList<Path> expanded = new ArrayList<Path>();
        if (opt.args().isEmpty()) {
            expanded.add(currentDir);
        } else {
            opt.args().stream().flatMap(s -> GroovyPosixCommands.maybeExpandGlob(context, s)).forEach(expanded::add);
        }
        boolean listAll = opt.isSet("a");
        Predicate<Path> filter = p -> listAll || p.getFileName() == null || p.getFileName().toString().equals(".") || p.getFileName().toString().equals("..") || !p.getFileName().toString().startsWith(".");
        List all = expanded.stream().filter(filter).map(p -> new PathEntry((Path)p, currentDir)).sorted().collect(Collectors.toList());
        List files = all.stream().filter(PathEntry::isNotDirectory).collect(Collectors.toList());
        PrintStream out = context.out();
        Consumer<Stream> display = s -> {
            boolean optLine = opt.isSet("1");
            boolean optComma = opt.isSet("m");
            boolean optLong = opt.isSet("l");
            boolean optCol = opt.isSet("C");
            if (!(optLine || optComma || optLong || optCol)) {
                if (context.isTty()) {
                    optCol = true;
                } else {
                    optLine = true;
                }
            }
            if (optLine) {
                s.map(PathEntry::display).forEach(out::println);
            } else if (optComma) {
                out.println(s.map(PathEntry::display).collect(Collectors.joining(", ")));
            } else if (optLong) {
                s.map(PathEntry::longDisplay).forEach(out::println);
            } else if (optCol) {
                GroovyPosixCommands.toColumn(context, out, s.map(PathEntry::display), opt.isSet("x"));
            }
        };
        boolean space = false;
        if (!files.isEmpty()) {
            display.accept(files.stream());
            space = true;
        }
        List directories = all.stream().filter(PathEntry::isDirectory).collect(Collectors.toList());
        for (PathEntry entry : directories) {
            if (space) {
                out.println();
            }
            space = true;
            Path path = currentDir.resolve(entry.path);
            if (expanded.size() > 1) {
                out.println(currentDir.relativize(path).toString() + ":");
            }
            Stream<Path> pathStream = Files.list(path);
            try {
                display.accept(Stream.concat(Stream.of(".", "..").map(path::resolve), pathStream).filter(filter).map(p -> new PathEntry((Path)p, path)).sorted());
            }
            finally {
                if (pathStream == null) continue;
                pathStream.close();
            }
        }
    }

    private static void toColumn(PosixCommands.Context context, PrintStream out, Stream<String> ansi, boolean horizontal) {
        Terminal terminal = context.terminal();
        int width = context.isTty() ? terminal.getWidth() : 80;
        List strings = ansi.map(AttributedString::fromAnsi).collect(Collectors.toList());
        if (!strings.isEmpty()) {
            int c;
            int max = strings.stream().mapToInt(AttributedCharSequence::columnLength).max().getAsInt();
            for (c = Math.max(1, width / max); c > 1 && c * max + (c - 1) >= width; --c) {
            }
            int columns = c;
            int lines = (strings.size() + columns - 1) / columns;
            IntBinaryOperator index = horizontal ? (i, j) -> i * columns + j : (i, j) -> j * lines + i;
            AttributedStringBuilder sb = new AttributedStringBuilder();
            for (int i2 = 0; i2 < lines; ++i2) {
                for (int j2 = 0; j2 < columns; ++j2) {
                    int idx = index.applyAsInt(i2, j2);
                    if (idx >= strings.size()) continue;
                    AttributedString str = (AttributedString)strings.get(idx);
                    boolean hasRightItem = j2 < columns - 1 && index.applyAsInt(i2, j2 + 1) < strings.size();
                    sb.append(str);
                    if (!hasRightItem) continue;
                    for (int k = 0; k <= max - str.length(); ++k) {
                        sb.append(' ');
                    }
                }
                sb.append('\n');
            }
            out.print(sb.toAnsi(terminal));
        }
    }

    public static void grep(PosixCommands.Context context, Object[] argv) throws Exception {
        List<NamedInputStream> sources;
        boolean filenameHeader;
        Map colors;
        boolean colored;
        String color;
        String lineFmt;
        Pattern p2;
        Pattern p;
        String[] usage = new String[]{"/grep -  search for PATTERN in each FILE or VARIABLE or standard input.", "Usage: /grep [OPTIONS] PATTERN [FILE|VARIABLE ...]", "  -? --help                Show help", "  -i --ignore-case         Ignore case distinctions", "  -n --line-number         Prefix each line with line number within its input file", "  -q --quiet, --silent     Suppress all normal output", "  -v --invert-match        Select non-matching lines", "  -w --word-regexp         Select only whole words", "  -x --line-regexp         Select only whole lines", "  -c --count               Only print a count of matching lines per file", "  -z --zero                When used with -c, don't print a count of zero", "  -H --with-filename       Display filename header for each file (defaults to true if multiple files are given)", "  -h --no-filename         Do not display filename header", "     --color=WHEN          Use markers to distinguish the matching string, may be `always', `never' or `auto'", "  -B --before-context=NUM  Print NUM lines of leading context before matching lines", "  -A --after-context=NUM   Print NUM lines of trailing context after matching lines", "  -C --context=NUM         Print NUM lines of output context", "     --pad-lines           Pad line numbers"};
        Options opt = GroovyPosixCommands.parseOptions((PosixCommands.Context)context, (String[])usage, (Object[])argv);
        Map colorMap = GroovyPosixCommands.getColorMap((PosixCommands.Context)context, (String)"GREP", (String)"mt=1;31:fn=35:ln=32:se=36");
        List args = opt.args();
        if (args.isEmpty()) {
            throw new IllegalArgumentException("no pattern supplied");
        }
        String regex = (String)args.remove(0);
        Object regexp = regex;
        if (opt.isSet("word-regexp")) {
            regexp = "\\b" + (String)regexp + "\\b";
        }
        regexp = opt.isSet("line-regexp") ? "^" + (String)regexp + "$" : ".*" + (String)regexp + ".*";
        if (opt.isSet("ignore-case")) {
            p = Pattern.compile((String)regexp, 2);
            p2 = Pattern.compile(regex, 2);
        } else {
            p = Pattern.compile((String)regexp);
            p2 = Pattern.compile(regex);
        }
        int after = opt.isSet("after-context") ? opt.getNumber("after-context") : -1;
        int before = opt.isSet("before-context") ? opt.getNumber("before-context") : -1;
        int contextLines = opt.isSet("context") ? opt.getNumber("context") : 0;
        String string = lineFmt = opt.isSet("pad-lines") ? "%6d" : "%d";
        if (after < 0) {
            after = contextLines;
        }
        if (before < 0) {
            before = contextLines;
        }
        boolean count = opt.isSet("count");
        boolean zero = opt.isSet("zero");
        boolean quiet = opt.isSet("quiet");
        boolean invert = opt.isSet("invert-match");
        boolean lineNumber = opt.isSet("line-number");
        switch (color = opt.isSet("color") ? opt.get("color") : "auto") {
            case "always": 
            case "yes": 
            case "force": {
                colored = true;
                break;
            }
            case "never": 
            case "no": 
            case "none": {
                colored = false;
                break;
            }
            case "auto": 
            case "tty": 
            case "if-tty": {
                colored = context.isTty();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid argument '" + color + "' for '--color'");
            }
        }
        Map map = colored ? (colorMap != null ? colorMap : GroovyPosixCommands.getColorMap((String)"mt=1;31:fn=35:ln=32:se=36")) : (colors = Collections.emptyMap());
        if (args.isEmpty()) {
            args.add("-");
        }
        boolean bl = filenameHeader = (sources = GroovyPosixCommands.getSources(context, argv, args)).size() > 1;
        if (opt.isSet("with-filename")) {
            filenameHeader = true;
        } else if (opt.isSet("no-filename")) {
            filenameHeader = false;
        }
        boolean match = false;
        for (NamedInputStream src : sources) {
            ArrayList<String> lines = new ArrayList<String>();
            boolean firstPrint = true;
            int nb = 0;
            InputStream is = src.getInputStream();
            try {
                try (BufferedReader r = new BufferedReader((Reader)new org.jline.utils.InputStreamReader(is));){
                    String line;
                    int lineno = 1;
                    int lineMatch = 0;
                    while ((line = r.readLine()) != null) {
                        boolean matches = p.matcher(line).matches();
                        if (invert) {
                            matches = !matches;
                        }
                        AttributedStringBuilder sbl = new AttributedStringBuilder();
                        if (matches) {
                            ++nb;
                            if (!count && !quiet) {
                                if (filenameHeader) {
                                    if (colored) {
                                        GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"fn"});
                                    }
                                    sbl.append((CharSequence)src.getName());
                                    if (colored) {
                                        GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"se"});
                                    }
                                    sbl.append((CharSequence)":");
                                }
                                if (lineNumber) {
                                    if (colored) {
                                        GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"ln"});
                                    }
                                    sbl.append((CharSequence)String.format(lineFmt, lineno));
                                    if (colored) {
                                        GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"se"});
                                    }
                                    sbl.append((CharSequence)":");
                                }
                                if (colored) {
                                    Matcher matcher2 = p2.matcher(line);
                                    int cur = 0;
                                    while (matcher2.find()) {
                                        GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"se"});
                                        sbl.append((CharSequence)line, cur, matcher2.start());
                                        GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"ms"});
                                        sbl.append((CharSequence)line, matcher2.start(), matcher2.end());
                                        GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"se"});
                                        cur = matcher2.end();
                                    }
                                    sbl.append((CharSequence)line, cur, line.length());
                                } else {
                                    sbl.append((CharSequence)line);
                                }
                                while (lineMatch > after && !lines.isEmpty()) {
                                    context.out().println((String)lines.remove(0));
                                    --lineMatch;
                                }
                                lineMatch = Math.min(before, lines.size()) + after + 1;
                            }
                        } else if (lineMatch > 0) {
                            context.out().println((String)lines.remove(0));
                            --lineMatch;
                            if (filenameHeader) {
                                if (colored) {
                                    GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"fn"});
                                }
                                sbl.append((CharSequence)src.getName());
                                if (colored) {
                                    GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"se"});
                                }
                                sbl.append((CharSequence)"-");
                            }
                            if (lineNumber) {
                                if (colored) {
                                    GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"ln"});
                                }
                                sbl.append((CharSequence)String.format(lineFmt, lineno));
                                if (colored) {
                                    GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"se"});
                                }
                                sbl.append((CharSequence)"-");
                            }
                            if (colored) {
                                GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"se"});
                            }
                            sbl.append((CharSequence)line);
                        } else {
                            if (filenameHeader) {
                                if (colored) {
                                    GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"fn"});
                                }
                                sbl.append((CharSequence)src.getName());
                                if (colored) {
                                    GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"se"});
                                }
                                sbl.append((CharSequence)"-");
                            }
                            if (lineNumber) {
                                if (colored) {
                                    GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"ln"});
                                }
                                sbl.append((CharSequence)String.format(lineFmt, lineno));
                                if (colored) {
                                    GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"se"});
                                }
                                sbl.append((CharSequence)"-");
                            }
                            if (colored) {
                                GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"se"});
                            }
                            sbl.append((CharSequence)line);
                            while (lines.size() > before) {
                                lines.remove(0);
                            }
                            lineMatch = 0;
                        }
                        lines.add(sbl.toAnsi(context.terminal()));
                        while (lineMatch == 0 && lines.size() > before) {
                            lines.remove(0);
                        }
                        ++lineno;
                    }
                    if (!count && lineMatch > 0) {
                        if (!firstPrint && before + after > 0) {
                            AttributedStringBuilder sbl2 = new AttributedStringBuilder();
                            if (colored) {
                                GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl2, (Map)colors, (String[])new String[]{"se"});
                            }
                            sbl2.append((CharSequence)"--");
                            context.out().println(sbl2.toAnsi(context.terminal()));
                        } else {
                            firstPrint = false;
                        }
                        for (int i = 0; i < lineMatch && i < lines.size(); ++i) {
                            context.out().println((String)lines.get(i));
                        }
                    }
                    if (count && (nb != 0 || !zero)) {
                        AttributedStringBuilder sbl = new AttributedStringBuilder();
                        if (filenameHeader) {
                            if (colored) {
                                GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"fn"});
                            }
                            sbl.append((CharSequence)src.getName());
                            if (colored) {
                                GroovyPosixCommands.applyStyle((AttributedStringBuilder)sbl, (Map)colors, (String[])new String[]{"se"});
                            }
                            sbl.append((CharSequence)":");
                        }
                        sbl.append((CharSequence)Integer.toString(nb));
                        context.out().println(sbl.toAnsi(context.terminal()));
                    }
                    match |= nb > 0;
                }
                context.out().flush();
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    public static void sort(PosixCommands.Context context, Object[] argv) throws Exception {
        String[] usage = new String[]{"/sort -  writes sorted standard input to standard output.", "Usage: /sort [OPTIONS] [FILES]", "  -? --help                    show help", "  -f --ignore-case             fold lower case to upper case characters", "  -r --reverse                 reverse the result of comparisons", "  -u --unique                  output only the first of an equal run", "  -t --field-separator=SEP     use SEP instead of non-blank to blank transition", "  -b --ignore-leading-blanks   ignore leading blancks", "     --numeric-sort            compare according to string numerical value", "  -k --key=KEY                 fields to use for sorting separated by whitespaces"};
        Options opt = GroovyPosixCommands.parseOptions((PosixCommands.Context)context, (String[])usage, (Object[])argv);
        List<String> args = opt.args();
        if (args.isEmpty()) {
            args = Collections.singletonList("-");
        }
        List<NamedInputStream> sources = GroovyPosixCommands.getSources(context, argv, args);
        ArrayList<String> lines = new ArrayList<String>();
        for (NamedInputStream s : sources) {
            try (BufferedReader reader = new BufferedReader((Reader)new org.jline.utils.InputStreamReader(s.getInputStream()));){
                GroovyPosixCommands.readLines(reader, lines);
            }
        }
        String separator = opt.get("field-separator");
        boolean caseInsensitive = opt.isSet("ignore-case");
        boolean reverse = opt.isSet("reverse");
        boolean ignoreBlanks = opt.isSet("ignore-leading-blanks");
        boolean numeric = opt.isSet("numeric-sort");
        boolean unique = opt.isSet("unique");
        List sortFields = opt.getList("key");
        char sep = separator == null || separator.length() == 0 ? (char)'\u0000' : separator.charAt(0);
        lines.sort((Comparator<String>)new PosixCommands.SortComparator(caseInsensitive, reverse, ignoreBlanks, numeric, sep, sortFields));
        String last = null;
        for (String s : lines) {
            if (!unique || last == null || !s.equals(last)) {
                context.out().println(s);
            }
            last = s;
        }
    }

    public static void less(PosixCommands.Context context, String[] argv) throws Exception {
        Options opt = GroovyPosixCommands.parseOptions((PosixCommands.Context)context, (String[])Less.usage(), (Object[])argv);
        ArrayList<Source.StdInSource> sources = new ArrayList<Source.StdInSource>();
        if (opt.args().isEmpty()) {
            opt.args().add("-");
        }
        for (String string : opt.args()) {
            if ("-".equals(string)) {
                sources.add(new Source.StdInSource(context.in()));
                continue;
            }
            GroovyPosixCommands.maybeExpandGlob(context, string).map(p -> {
                try {
                    return new Source.URLSource(p.toUri().toURL(), p.toString());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).forEach(sources::add);
        }
        if (!context.isTty()) {
            for (Source source : sources) {
                try (BufferedReader reader = new BufferedReader((Reader)new org.jline.utils.InputStreamReader(source.read()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        context.out().println(line);
                    }
                }
            }
            return;
        }
        Less less = new Less(context.terminal(), context.currentDir(), opt);
        less.run(sources);
    }

    private static List<NamedInputStream> getSources(PosixCommands.Context context, Object[] argv, List<String> args) {
        ArrayList<NamedInputStream> sources = new ArrayList<NamedInputStream>();
        for (String arg : args) {
            if ("-".equals(arg)) {
                sources.add(new NamedInputStream(context.in(), "(standard input)", false));
                continue;
            }
            if (arg.startsWith("[Ljava.lang.String;@")) {
                sources.add(new NamedInputStream(GroovyPosixCommands.variableInputStream(argv, arg), arg));
                continue;
            }
            sources.addAll(GroovyPosixCommands.maybeExpandGlob(context, arg).map(p -> new NamedInputStream((Path)p, p.toString())).collect(Collectors.toList()));
        }
        return sources;
    }

    private static ByteArrayInputStream variableInputStream(Object[] argv, String arg) {
        Object[] found = (String[])Arrays.stream(argv).filter(v -> v.toString().equals(arg)).findFirst().get();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(ArrayGroovyMethods.join((Object[])found, (String)"\n").getBytes(StandardCharsets.UTF_8));
        return inputStream;
    }

    private static LinkOption[] getLinkOptions(boolean followLinks) {
        if (followLinks) {
            return EMPTY_LINK_OPTIONS;
        }
        return (LinkOption[])NO_FOLLOW_OPTIONS.clone();
    }

    private static boolean isWindowsExecutable(String fileName) {
        if (fileName == null || fileName.length() <= 0) {
            return false;
        }
        for (String suffix : WINDOWS_EXECUTABLE_EXTENSIONS) {
            if (!fileName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static Set<PosixFilePermission> getPermissionsFromFile(Path f) {
        HashSet<PosixFilePermission> perms = new HashSet();
        try {
            perms = Files.getPosixFilePermissions(f, new LinkOption[0]);
        }
        catch (IOException | UnsupportedOperationException exception) {
            // empty catch block
        }
        if (OSUtils.IS_WINDOWS && GroovyPosixCommands.isWindowsExecutable(f.getFileName().toString())) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    private static void readLines(BufferedReader reader, List<String> lines) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
    }

    private static Stream<Path> maybeExpandGlob(PosixCommands.Context context, String s) {
        if (s.contains("*") || s.contains("?")) {
            return GroovyPosixCommands.expandGlob(context, s).stream();
        }
        return Stream.of(context.currentDir().resolve(s));
    }

    private static List<Path> expandGlob(PosixCommands.Context context, String pattern) {
        try {
            String[] includedDirs;
            String[] includedFiles;
            Class<?> directoryScannerClass = Class.forName("org.apache.tools.ant.DirectoryScanner");
            Object scanner = directoryScannerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ArrayList<Path> result = new ArrayList<Path>();
            Method setBasedirMethod = directoryScannerClass.getMethod("setBasedir", File.class);
            setBasedirMethod.invoke(scanner, context.currentDir().toFile());
            Method setIncludesMethod = directoryScannerClass.getMethod("setIncludes", String[].class);
            setIncludesMethod.invoke(scanner, new Object[]{new String[]{pattern}});
            Method scanMethod = directoryScannerClass.getMethod("scan", new Class[0]);
            scanMethod.invoke(scanner, new Object[0]);
            Method getIncludedFilesMethod = directoryScannerClass.getMethod("getIncludedFiles", new Class[0]);
            for (String file : includedFiles = (String[])getIncludedFilesMethod.invoke(scanner, new Object[0])) {
                result.add(Path.of(file, new String[0]));
            }
            Method getIncludedDirsMethod = directoryScannerClass.getMethod("getIncludedDirectories", new Class[0]);
            for (String dir : includedDirs = (String[])getIncludedDirsMethod.invoke(scanner, new Object[0])) {
                result.add(Path.of(dir, new String[0]));
            }
            return result;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException directoryScannerClass) {
            String globPart;
            Path base;
            Path path = Path.of(pattern, new String[0]);
            if (path.isAbsolute()) {
                base = path.getParent();
                globPart = path.getFileName().toString();
            } else {
                base = context.currentDir();
                globPart = pattern;
            }
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + globPart);
            try {
                return Files.list(base).filter(p -> matcher.matches(p.getFileName())).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class NamedInputStream
    implements Closeable {
        private InputStream inputStream;
        private final Path path;
        private final String name;
        private final boolean close;

        public NamedInputStream(InputStream inputStream, String name, boolean close) {
            this.inputStream = inputStream;
            this.path = null;
            this.name = name;
            this.close = close;
        }

        public NamedInputStream(InputStream inputStream, String name) {
            this(inputStream, name, true);
        }

        public NamedInputStream(Path path, String name) {
            this.inputStream = null;
            this.path = path;
            this.name = name;
            this.close = false;
        }

        public InputStream getInputStream() throws IOException {
            if (this.inputStream == null) {
                this.inputStream = this.path.toUri().toURL().openStream();
            }
            return this.inputStream;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void close() throws IOException {
            if (this.inputStream != null && this.close) {
                this.inputStream.close();
            }
        }
    }
}

