/*
 * Decompiled with CFR 0.152.
 */
package mill.util;

import geny.Writable;
import geny.Writable$;
import java.io.Serializable;
import mill.moduledefs.Scaladoc;
import mill.util.SpanningForest;
import mill.util.SpanningForest$Node$;
import os.Path;
import os.Source$;
import os.write$over$;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapFactory$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import ujson.Obj;
import ujson.Obj$;
import ujson.Value;

@Scaladoc(value="/**\n * Algorithm to compute the minimal spanning forest of a directed acyclic graph\n * that covers a particular subset of [[importantVertices]] (a \"Steiner Forest\"),\n * minimizing the maximum height of the resultant trees. When multiple solutions\n * exist with the same height, one chosen is arbitrarily. (This is much simpler\n * than the \"real\" algorithm which aims to minimize the sum of edge/vertex weights)\n *\n * Returns the forest as a [[Node]] structure with the top-level node containing\n * the roots of the forest\n */")
public final class SpanningForest$ {
    public static final SpanningForest$ MODULE$ = new SpanningForest$();

    public <T> Tuple2<Map<T, Object>, int[][]> graphMapToIndices(Iterable<T> vertices, Map<T, Seq<T>> edges) {
        Map vertexToIndex = ((IterableOnceOps)vertices.zipWithIndex()).toMap($less$colon$less$.MODULE$.refl());
        int[][] edgeIndices = (int[][])((IterableOnceOps)vertices.map((Function1<Object, int[]> & Serializable)t -> (int[])((IterableOnceOps)((IterableOps)edges.getOrElse(t, (Function0<Nil$> & Serializable)() -> Nil$.MODULE$)).flatMap((Function1<Object, Option> & Serializable)x$1 -> vertexToIndex.get(x$1))).toArray(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        return new Tuple2<Map<T, Object>, int[][]>(vertexToIndex, edgeIndices);
    }

    public void writeJsonFile(Path path, int[][] indexEdges, scala.collection.immutable.Set<Object> interestingIndices, Function1<Object, String> render) {
        Obj qual$1 = this.writeJson(indexEdges, interestingIndices, render);
        int x$1 = 2;
        boolean x$2 = qual$1.render$default$2();
        String json = qual$1.render(2, x$2);
        write$over$.MODULE$.apply(path, Source$.MODULE$.WritableSource(json, (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s)), write$over$.MODULE$.apply$default$3(), write$over$.MODULE$.apply$default$4(), write$over$.MODULE$.apply$default$5(), write$over$.MODULE$.apply$default$6());
    }

    public Obj writeJson(int[][] indexEdges, scala.collection.immutable.Set<Object> interestingIndices, Function1<Object, String> render) {
        SpanningForest.Node forest = this.apply(indexEdges, interestingIndices, true);
        return this.spanningTreeToJsonTree(forest, render);
    }

    public Obj spanningTreeToJsonTree(SpanningForest.Node node, Function1<Object, String> stringify) {
        return Obj$.MODULE$.from((IterableOnce<Tuple2<String, Value>>)node.values().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int k = tuple2._1$mcI$sp();
                SpanningForest.Node v = (SpanningForest.Node)tuple2._2();
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(stringify.apply(BoxesRunTime.boxToInteger(k))), MODULE$.spanningTreeToJsonTree(v, stringify));
            }
            throw new MatchError(tuple2);
        }));
    }

    public SpanningForest.Node apply(int[][] indexGraphEdges, scala.collection.immutable.Set<Object> importantVertices, boolean limitToImportantVertices) {
        scala.collection.immutable.Set destinations = (scala.collection.immutable.Set)importantVertices.flatMap((Function1<Object, ArraySeq.ofInt> & Serializable)x$2 -> Predef$.MODULE$.wrapIntArray(indexGraphEdges[BoxesRunTime.unboxToInt(x$2)]));
        scala.collection.immutable.Set rootChangedNodeIndices = (scala.collection.immutable.Set)importantVertices.filter(x$3 -> !destinations.contains(BoxesRunTime.boxToInteger(x$3)));
        scala.collection.mutable.Map nodeMapping = ((IterableOnceOps)rootChangedNodeIndices.map((Function1<Object, Tuple2> & Serializable)x$4 -> SpanningForest$.$anonfun$apply$3(BoxesRunTime.unboxToInt(x$4)))).to(MapFactory$.MODULE$.toFactory(Map$.MODULE$));
        SpanningForest.Node spanningForest = new SpanningForest.Node((scala.collection.mutable.Map)nodeMapping.clone());
        this.breadthFirst(rootChangedNodeIndices, (Function1<Object, ArraySeq.ofInt> & Serializable)index -> SpanningForest$.$anonfun$apply$4(indexGraphEdges, limitToImportantVertices, importantVertices, nodeMapping, BoxesRunTime.unboxToInt(index)));
        return spanningForest;
    }

    public <T> Seq<T> breadthFirst(IterableOnce<T> start, Function1<T, IterableOnce<T>> edges) {
        Set seen = (Set)Set$.MODULE$.empty();
        Buffer seenList = (Buffer)Buffer$.MODULE$.empty();
        Object queued = Queue$.MODULE$.from((IterableOnce)start);
        while (((AbstractIterable)queued).nonEmpty()) {
            Object current = ((Queue)queued).dequeue();
            seenList.append(current);
            IterableOnceExtensionMethods$.MODULE$.foreach$extension(IterableOnce$.MODULE$.iterableOnceExtensionMethods(edges.apply(current)), arg_0 -> SpanningForest$.$anonfun$breadthFirst$1(seen, (Queue)queued, arg_0));
        }
        return seenList.toSeq();
    }

    public <T, V> Map<V, Vector<T>> reverseEdges(Iterable<Tuple2<T, Iterable<V>>> edges) {
        Vector flatEdges = edges.iterator().flatMap((Function1<Tuple2, Iterable> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Iterable vs = (Iterable)tuple2._2();
                return (Iterable)vs.map((Function1<Object, Tuple2> & Serializable)x$5 -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), k));
            }
            throw new MatchError(tuple2);
        }).toVector();
        return flatEdges.groupMap((Function1<Tuple2, Object> & Serializable)x$6 -> x$6._1(), (Function1<Tuple2, Object> & Serializable)x$7 -> x$7._2()).mapValues((Function1<Vector, Vector> & Serializable)x$8 -> (Vector)x$8.toSeq()).toMap($less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Tuple2 $anonfun$apply$3(int x$4) {
        return new Tuple2<Integer, SpanningForest.Node>(BoxesRunTime.boxToInteger(x$4), new SpanningForest.Node(SpanningForest$Node$.MODULE$.apply$default$1()));
    }

    public static final /* synthetic */ ArraySeq.ofInt $anonfun$apply$4(int[][] indexGraphEdges$1, boolean limitToImportantVertices$1, scala.collection.immutable.Set importantVertices$1, scala.collection.mutable.Map nodeMapping$1, int index) {
        int[] nextIndices = (int[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.intArrayOps(indexGraphEdges$1[index]), e -> !limitToImportantVertices$1 || importantVertices$1.apply(BoxesRunTime.boxToInteger(e)));
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.intArrayOps(nextIndices), nextIndex -> !nodeMapping$1.contains(BoxesRunTime.boxToInteger(nextIndex))).foreach(nextIndex -> {
            SpanningForest.Node node = new SpanningForest.Node(SpanningForest$Node$.MODULE$.apply$default$1());
            nodeMapping$1.update(BoxesRunTime.boxToInteger(nextIndex), node);
            ((SpanningForest.Node)nodeMapping$1.apply(BoxesRunTime.boxToInteger(index))).values().update(BoxesRunTime.boxToInteger(nextIndex), node);
        });
        return Predef$.MODULE$.wrapIntArray(nextIndices);
    }

    public static final /* synthetic */ Object $anonfun$breadthFirst$1(Set seen$1, Queue queued$1, Object next) {
        if (!seen$1.contains(next)) {
            seen$1.add(next);
            return queued$1.enqueue(next);
        }
        return BoxedUnit.UNIT;
    }

    private SpanningForest$() {
    }
}

