/*
 * Decompiled with CFR 0.152.
 */
package mill.main.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProxyStream {
    public static final int OUT = 1;
    public static final int ERR = -1;
    public static final int END = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendEnd(OutputStream outputStream) throws IOException {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            outputStream.write(0);
            outputStream.flush();
        }
    }

    public static class Pumper
    implements Runnable {
        private InputStream src;
        private OutputStream destOut;
        private OutputStream destErr;
        private Object synchronizer;

        public Pumper(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, Object object) {
            this.src = inputStream;
            this.destOut = outputStream;
            this.destErr = outputStream2;
            this.synchronizer = object;
        }

        public Pumper(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
            this(inputStream, outputStream, outputStream2, new Object());
        }

        public void preRead(InputStream inputStream) {
        }

        public void write(OutputStream outputStream, byte[] byArray, int n) throws IOException {
            outputStream.write(byArray, 0, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            byte[] byArray = new byte[1024];
            try {
                while (true) {
                    this.preRead(this.src);
                    int n = this.src.read();
                    if (n != -1 && n != 0) {
                        int n2;
                        int n3 = (byte)n > 0 ? 1 : -1;
                        byte by = (byte)n;
                        int n4 = Math.abs(by);
                        int n5 = -1;
                        for (n2 = 0; n2 < n4; n2 += n5) {
                            this.preRead(this.src);
                            n5 = this.src.read(byArray, n2, n4 - n2);
                            if (n5 == -1) break;
                        }
                        if (n5 == -1) continue;
                        Object object = this.synchronizer;
                        synchronized (object) {
                            switch (n3) {
                                case 1: {
                                    this.write(this.destOut, byArray, n2);
                                    break;
                                }
                                case -1: {
                                    this.write(this.destErr, byArray, n2);
                                    break;
                                }
                            }
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Object object = this.synchronizer;
                synchronized (object) {
                    this.destOut.flush();
                    this.destErr.flush();
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            Object object = this.synchronizer;
            synchronized (object) {
                this.destOut.flush();
                this.destErr.flush();
            }
        }
    }

    public static class Output
    extends OutputStream {
        private OutputStream destination;
        private int key;

        public Output(OutputStream outputStream, int n) {
            this.destination = outputStream;
            this.key = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int n) throws IOException {
            OutputStream outputStream = this.destination;
            synchronized (outputStream) {
                this.destination.write(this.key);
                this.destination.write(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] byArray) throws IOException {
            if (byArray.length > 0) {
                OutputStream outputStream = this.destination;
                synchronized (outputStream) {
                    this.write(byArray, 0, byArray.length);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            OutputStream outputStream = this.destination;
            synchronized (outputStream) {
                int n3 = 0;
                while (n3 < n2 && n3 + n < byArray.length) {
                    int n4 = Math.min(n2 - n3, 127);
                    if (n4 <= 0) continue;
                    this.destination.write(n4 * this.key);
                    this.destination.write(byArray, n + n3, Math.min(byArray.length - n - n3, n4));
                    n3 += n4;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            OutputStream outputStream = this.destination;
            synchronized (outputStream) {
                this.destination.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            OutputStream outputStream = this.destination;
            synchronized (outputStream) {
                this.destination.close();
            }
        }
    }
}

